/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.tutorial;

import com.sun.javafx.application.PlatformImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pro2e.DPIFixV3;
import pro2e.userinterface.Utility;

public class SwingFXWebView
extends JPanel {
    private static final long serialVersionUID = 1837587643723839656L;
    private Stage stage;
    private WebView browser;
    private JFXPanel jfxPanel;
    private WebEngine webEngine;
    private JButton swingButton;

    public SwingFXWebView() {
        this.initComponents();
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.getContentPane().add(new SwingFXWebView());
                frame.setMinimumSize(new Dimension(DPIFixV3.screen.width / 2, DPIFixV3.screen.height / 5 * 4));
                frame.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.jfxPanel = new JFXPanel();
        this.createScene();
        this.setLayout(new GridBagLayout());
        this.swingButton = new JButton();
        this.swingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (SwingFXWebView.this.webEngine.getHistory().getCurrentIndex() != 0) {
                            SwingFXWebView.this.goHome();
                        }
                    }
                });
            }
        });
        this.swingButton.setText("Tutorial neu starten");
        this.add((Component)this.jfxPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.swingButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void goHome() {
        final WebHistory history = this.webEngine.getHistory();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                history.go(-history.getCurrentIndex());
            }
        });
    }

    private void createScene() {
        PlatformImpl.startup((Runnable)new Runnable(){

            @Override
            public void run() {
                SwingFXWebView.this.stage = new Stage();
                SwingFXWebView.this.stage.setTitle("Donut Tutorial");
                SwingFXWebView.this.stage.setResizable(false);
                StackPane root = new StackPane();
                Scene scene = new Scene((Parent)root, 80.0, 20.0);
                SwingFXWebView.this.stage.setScene(scene);
                SwingFXWebView.this.browser = new WebView();
                SwingFXWebView.this.webEngine = SwingFXWebView.this.browser.getEngine();
                URL url = Utility.loadResourceUrl("1_Antennen.html");
                SwingFXWebView.this.webEngine.load(url.toString());
                ObservableList children = root.getChildren();
                children.add((Object)SwingFXWebView.this.browser);
                SwingFXWebView.this.jfxPanel.setScene(scene);
            }
        });
    }
}

