/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.plots;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.Observable;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pro2e.DPIFixV3;
import pro2e.TraceV1;
import pro2e.matlabfunctions.MiniMatlab;
import pro2e.model.Model;
import pro2e.userinterface.MyBorderFactory;
import pro2e.userinterface.plots.PlotPanelKart;
import pro2e.userinterface.plots.PlotPanelPol;

public class TabbedPlotPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TraceV1 trace = new TraceV1(this);
    private PlotPanelKart plotPanelKart = new PlotPanelKart();
    private PlotPanelPol plotPanelPol = new PlotPanelPol();

    public TabbedPlotPanel() {
        super(new GridLayout());
        this.trace.constructorCall();
        this.setMinimumSize(new Dimension(DPIFixV3.screen.width / 5, 0));
        this.setBorder(MyBorderFactory.createMyBorder(" Plots "));
        JPanel asdf = new JPanel();
        asdf.setBackground(Color.black);
        JTabbedPane tabpane = new JTabbedPane(1, 1);
        tabpane.addTab("kartesisch", this.plotPanelKart);
        tabpane.addTab("polar", this.plotPanelPol);
        this.add(tabpane);
        this.setVisible(true);
    }

    public double get3dbAngle(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        return model.getAntArray().get3dbAngle();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.trace.methodeCall();
        super.paintComponent(g);
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        double[] phi = MiniMatlab.linspace(0.0, 360.0, 361);
        model.setnMeasures(phi.length);
        double[] intensity = model.getPlot();
        this.plotPanelKart.setData(phi, intensity);
        this.plotPanelPol.setData(phi, intensity);
    }

    public void resetAxis(boolean plotAxisDb) {
        this.trace.methodeCall();
        this.plotPanelKart.resetAxis(plotAxisDb);
        this.plotPanelPol.resetAxis(plotAxisDb);
    }
}

