/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.plots;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pro2e.DonutFramework;
import pro2e.TraceV1;
import pro2e.matlabfunctions.MiniMatlab;
import pro2e.model.Model;
import pro2e.userinterface.plots.JFreeChartDPIFix;

public class PlotPanelPol
extends JPanel {
    private static final long serialVersionUID = -4522467773085225830L;
    private JFreeChart chart;
    private TraceV1 trace = new TraceV1(this);

    public PlotPanelPol() {
        super(new GridBagLayout());
        this.trace.constructorCall();
        this.chart = ChartFactory.createPolarChart("Strahlungsdiagramm", null, false, false, false);
        this.chart.setBackgroundPaint(this.getBackground());
        PolarPlot polplot = (PolarPlot)this.chart.getPlot();
        JFreeChartDPIFix.applyChartTheme(this.chart);
        polplot.setRadiusMinorGridlinesVisible(false);
        polplot.setBackgroundPaint(Color.WHITE);
        polplot.setAngleGridlinePaint(Color.GRAY);
        polplot.setRadiusGridlinePaint(Color.GRAY);
        this.chart.setBackgroundPaint(Color.WHITE);
        ValueAxis rAxis = polplot.getAxis(0);
        rAxis.setRange(-40.0, 0.0);
        rAxis.setAutoRange(false);
        rAxis.setTickLabelsVisible(true);
        rAxis.setLabel("Intensit\u00e4t dB");
        DefaultPolarItemRenderer renderer = (DefaultPolarItemRenderer)polplot.getRenderer();
        renderer.setSeriesStroke(0, new BasicStroke(3.0f));
        renderer.setSeriesPaint(0, DonutFramework.Colors.Blue);
        renderer.setShapesVisible(false);
        polplot.setRenderer(0, renderer);
        polplot.setAngleOffset(180.0);
        this.add((Component)new ChartPanel(this.chart), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void resetAxis(boolean plotScaleDb) {
        this.trace.methodeCall();
        PolarPlot polplot = (PolarPlot)this.chart.getPlot();
        ValueAxis rAxis = polplot.getAxis(0);
        if (plotScaleDb) {
            rAxis.setRange(-40.0, 0.0);
            rAxis.setLabel("Intensit\u00e4t dB");
        } else {
            rAxis.setRange(0.0, 1.0);
            rAxis.setLabel("Intensit\u00e4t linear");
        }
        rAxis.setAutoRange(false);
    }

    public void setData(double[] x, double[] y1) {
        this.trace.methodeCall();
        XYSeries series = new XYSeries((Comparable)((Object)"Plot1"));
        int i = 0;
        while (i < y1.length) {
            if (Double.isNaN(y1[i])) {
                y1[i] = -500.0;
            }
            ++i;
        }
        i = 0;
        while (i < x.length) {
            series.add(x[i], y1[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        ((PolarPlot)this.chart.getPlot()).setDataset(0, dataset);
        this.repaint();
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        double[] phi = MiniMatlab.linspace(0.0, 360.0, 361);
        model.getAntArray().setnMeasures(phi.length);
        double[] intensity = model.getAntArray().getLinearPhasedArrayPlot();
        this.setData(phi, intensity);
    }
}

