/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.plots;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pro2e.DonutFramework;
import pro2e.TraceV1;
import pro2e.matlabfunctions.MiniMatlab;
import pro2e.model.Model;
import pro2e.userinterface.plots.JFreeChartDPIFix;

public class PlotPanelKart
extends JPanel {
    private static final long serialVersionUID = -4522467773085225830L;
    private JFreeChart chart = ChartFactory.createXYLineChart("Strahlungsdiagramm", "Abstrahlwinkel [\u03c6] \u00b0", "Intensit\u00e4t dB", null, PlotOrientation.VERTICAL, false, false, false);
    private TraceV1 trace = new TraceV1(this);

    public PlotPanelKart() {
        super(new GridBagLayout());
        this.trace.constructorCall();
        this.chart.setBackgroundPaint(this.getBackground());
        XYPlot xyplot = this.chart.getXYPlot();
        ValueAxis xAxis = xyplot.getDomainAxis(0);
        xAxis.setRange(0.0, 360.0);
        xAxis.setAutoRange(false);
        xAxis.setTickLabelsVisible(true);
        ValueAxis yAxis = xyplot.getRangeAxis(0);
        yAxis.setRange(-60.0, 0.0);
        yAxis.setAutoRange(false);
        yAxis.setTickLabelsVisible(true);
        JFreeChartDPIFix.applyChartTheme(this.chart);
        xyplot.setBackgroundPaint(Color.WHITE);
        xyplot.setDomainGridlinePaint(Color.GRAY);
        xyplot.setRangeGridlinePaint(Color.GRAY);
        this.chart.setBackgroundPaint(Color.WHITE);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(0, new BasicStroke(3.0f, 0, 2));
        renderer.setSeriesPaint(0, DonutFramework.Colors.Blue);
        xyplot.setRenderer(0, renderer);
        renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(1, new BasicStroke(2.0f, 0, 2));
        renderer.setSeriesPaint(0, Color.GRAY);
        xyplot.setRenderer(1, renderer);
        this.add((Component)new ChartPanel(this.chart), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void resetAxis(boolean plotScaleDb) {
        this.trace.methodeCall();
        XYPlot xyplot = this.chart.getXYPlot();
        ValueAxis xAxis = xyplot.getDomainAxis(0);
        xAxis.setRange(0.0, 360.0);
        xAxis.setAutoRange(false);
        ValueAxis yAxis = xyplot.getRangeAxis(0);
        if (plotScaleDb) {
            yAxis.setRange(-60.0, 0.0);
            yAxis.setLabel("Intensit\u00e4t dB");
        } else {
            yAxis.setRange(0.0, 1.0);
            yAxis.setLabel("Intensit\u00e4t linear");
        }
        yAxis.setAutoRange(false);
    }

    public void setData(double[] x, double[] y1) {
        this.trace.methodeCall();
        XYSeries series = new XYSeries((Comparable)((Object)"Plot1"));
        int i = 0;
        while (i < x.length) {
            series.add(x[i], y1[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart.getXYPlot().setDataset(0, dataset);
        dataset = new XYSeriesCollection();
        series = new XYSeries((Comparable)((Object)"Plot2"));
        int i2 = 0;
        while (i2 < x.length) {
            ++i2;
        }
        dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart.getXYPlot().setDataset(1, dataset);
        this.repaint();
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        double[] phi = MiniMatlab.linspace(0.0, 360.0, 361);
        double[] intensity = model.getAntArray().getLinearPhasedArrayPlot();
        this.setData(phi, intensity);
    }
}

