/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.plots;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Observable;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pro2e.DPIFixV3;
import pro2e.DonutFramework;
import pro2e.TraceV1;
import pro2e.matlabfunctions.Fensterfunktionen;
import pro2e.matlabfunctions.MiniMatlab;
import pro2e.model.Model;
import pro2e.userinterface.MyBorderFactory;
import pro2e.userinterface.plots.JFreeChartDPIFix;

public class PlotPanelAmplituden
extends JPanel {
    private static final long serialVersionUID = -4522467773085225830L;
    private JFreeChart chart = ChartFactory.createXYLineChart("", "Antennen", "Amplitude", null, PlotOrientation.VERTICAL, false, false, false);
    private TraceV1 trace = new TraceV1(this);

    public PlotPanelAmplituden() {
        super(new BorderLayout());
        this.trace.constructorCall();
        this.setPreferredSize(new Dimension(DPIFixV3.screen.width / 5, DPIFixV3.screen.height / 3));
        this.setBorder(MyBorderFactory.createMyBorder(" Fensterfunktion "));
        this.chart.setBackgroundPaint(this.getBackground());
        XYPlot xyplot = this.chart.getXYPlot();
        ValueAxis xAxis = xyplot.getDomainAxis(0);
        xAxis.setRange(0.0, 1.0);
        xAxis.setAutoRange(false);
        xAxis.setTickLabelsVisible(false);
        ValueAxis yAxis = xyplot.getRangeAxis(0);
        yAxis.setRange(0.0, 1.1);
        yAxis.setAutoRange(false);
        yAxis.setTickLabelsVisible(false);
        yAxis.setTickLabelsVisible(true);
        JFreeChartDPIFix.applyChartTheme(this.chart);
        xyplot.setBackgroundPaint(Color.WHITE);
        xyplot.setDomainGridlinePaint(Color.GRAY);
        xyplot.setRangeGridlinePaint(Color.GRAY);
        this.chart.setBackgroundPaint(this.getBackground());
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(0, new BasicStroke(3.0f, 0, 2));
        renderer.setSeriesPaint(0, DonutFramework.Colors.Pink);
        xyplot.setRenderer(0, renderer);
        renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(0, new BasicStroke(3.0f, 0, 2));
        renderer.setSeriesPaint(0, Color.BLACK);
        xyplot.setRenderer(1, renderer);
        renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(0, new BasicStroke(3.0f, 0, 2));
        renderer.setSeriesPaint(0, Color.GRAY);
        xyplot.setRenderer(2, renderer);
        this.add(new ChartPanel(this.chart));
    }

    public void resetAxis() {
        this.trace.methodeCall();
        XYPlot xyplot = this.chart.getXYPlot();
        ValueAxis xAxis = xyplot.getDomainAxis(0);
        xAxis.setRange(0.0, 1.0);
        xAxis.setAutoRange(false);
        ValueAxis yAxis = xyplot.getRangeAxis(0);
        yAxis.setRange(0.0, 1.1);
        yAxis.setAutoRange(false);
    }

    public void setData(double[] x, double[] y1, double[] y2, double[] y3) {
        this.trace.methodeCall();
        XYSeries series = new XYSeries((Comparable)((Object)"Plot1"));
        int i = 0;
        while (i < x.length) {
            series.add(x[i], y1[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart.getXYPlot().setDataset(2, dataset);
        series = new XYSeries((Comparable)((Object)"Plot2"));
        int i2 = 0;
        while (i2 < x.length) {
            series.add(x[i2], y2[i2]);
            ++i2;
        }
        dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart.getXYPlot().setDataset(1, dataset);
        series = new XYSeries((Comparable)((Object)"Plot3"));
        i2 = 0;
        while (i2 < x.length) {
            series.add(x[i2], y3[i2]);
            ++i2;
        }
        dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart.getXYPlot().setDataset(0, dataset);
        this.repaint();
        this.resetAxis();
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        int nAnt = model.getNAnt();
        int nw = 301;
        int d = nw / nAnt;
        int N = d * nAnt;
        double[] xx = MiniMatlab.linspace(0.0, 1.0, N);
        double[] y1 = new double[N];
        double[] y3 = new double[N];
        int type = model.getWindow();
        double[] y4small = new double[nAnt];
        switch (type) {
            case 2: {
                y4small = Fensterfunktionen.Binominal(nAnt);
                break;
            }
            case 1: {
                y4small = Fensterfunktionen.Chebwin(nAnt, model.getWindowParam());
                break;
            }
            case 3: {
                y1 = Fensterfunktionen.Cosin(N, model.getWindowParam());
                y4small = Fensterfunktionen.Cosin(nAnt, model.getWindowParam());
                break;
            }
            case 4: {
                y1 = Fensterfunktionen.CosinSquare(N, model.getWindowParam());
                y4small = Fensterfunktionen.CosinSquare(nAnt, model.getWindowParam());
                break;
            }
            case 12: {
                y1 = Fensterfunktionen.Exponential(N, model.getWindowParam());
                y4small = Fensterfunktionen.Exponential(nAnt, model.getWindowParam());
                break;
            }
            case 11: {
                y1 = Fensterfunktionen.Triangular(N);
                y4small = Fensterfunktionen.Triangular(nAnt);
                break;
            }
            default: {
                y1 = Fensterfunktionen.Rectangular(N);
                y4small = Fensterfunktionen.Rectangular(nAnt);
            }
        }
        double[] y4 = new double[N];
        int i = 0;
        while (i < y4small.length) {
            int j = 0;
            while (j < d) {
                y4[i * d + j] = y4small[i];
                ++j;
            }
            ++i;
        }
        y3 = model.isDiskretisierung() ? Fensterfunktionen.Quantize(y4, model.getnBits()) : y4;
        if (type == 1 || type == 2) {
            y1 = y4;
        }
        this.setData(xx, y1, y4, y3);
    }
}

