/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.plots;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Observable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pro2e.DPIFixV3;
import pro2e.matlabfunctions.Fensterfunktionen;
import pro2e.matlabfunctions.MiniMatlab;
import pro2e.userinterface.plots.JFreeChartDPIFix;

public class PlotPanel
extends JPanel {
    private static final long serialVersionUID = -4522467773085225830L;
    private JFreeChart chart = ChartFactory.createXYLineChart("Titel", "x - Achse", "y - Achse", null, PlotOrientation.VERTICAL, false, false, false);

    public PlotPanel() {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(DPIFixV3.screen.width / 3, DPIFixV3.screen.height / 3));
        this.chart.setBackgroundPaint(this.getBackground());
        XYPlot xyplot = this.chart.getXYPlot();
        xyplot.setBackgroundPaint(this.getBackground());
        xyplot.setRangeGridlinePaint(Color.black);
        xyplot.setDomainGridlinePaint(Color.black);
        ValueAxis xAxis = xyplot.getDomainAxis(0);
        xAxis.setRange(0.0, 1.0);
        xAxis.setAutoRange(false);
        xAxis.setTickLabelsVisible(true);
        ValueAxis yAxis = xyplot.getRangeAxis(0);
        yAxis.setRange(0.0, 1.0);
        yAxis.setAutoRange(false);
        yAxis.setTickLabelsVisible(true);
        JFreeChartDPIFix.applyChartTheme(this.chart);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(0, new BasicStroke(1.0f, 0, 2));
        renderer.setSeriesPaint(0, Color.blue);
        xyplot.setRenderer(0, renderer);
        renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(0, new BasicStroke(1.0f, 0, 2));
        renderer.setSeriesPaint(0, Color.red);
        xyplot.setRenderer(1, renderer);
        this.add(new ChartPanel(this.chart));
        this.update(null, null);
    }

    public void setData(double[] x, double[] y1, double[] y2) {
        XYPlot xyplot = this.chart.getXYPlot();
        ValueAxis xAxis = xyplot.getDomainAxis(0);
        xAxis.setRange(0.0, x.length);
        XYSeries series = new XYSeries((Comparable)((Object)"Plot1"));
        int i = 0;
        while (i < x.length) {
            series.add(x[i], y1[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart.getXYPlot().setDataset(0, dataset);
        series = new XYSeries((Comparable)((Object)"Plot2"));
        int i2 = 0;
        while (i2 < x.length) {
            series.add(x[i2], y2[i2]);
            ++i2;
        }
        dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart.getXYPlot().setDataset(1, dataset);
        this.repaint();
    }

    public void update(Observable obs, Object obj) {
        double[] n = MiniMatlab.linspace(0.0, 99.0, 100);
        double[] f1 = Fensterfunktionen.Cosin(n.length, 0.0);
        double[] f2 = new double[n.length];
        int i = 0;
        while (i < f2.length) {
            double phi = (double)(i * 2) * Math.PI / (double)n.length;
            f2[i] = Math.abs(Math.sin(phi)) > 1.0E-5 ? Math.abs(Math.cos(1.5707963267948966 * Math.cos(phi)) / Math.sin(phi)) : 0.0;
            ++i;
        }
        System.out.println(f1.length);
        System.out.println(f1[0]);
        this.setData(n, f2, f2);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.setTitle("MVCFramework");
                frame.add(new PlotPanel());
                DPIFixV3.scaleSwingFonts();
                SwingUtilities.updateComponentTreeUI(frame);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

