/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.plots;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pro2e.DPIFixV3;
import pro2e.TraceV1;
import pro2e.model.Model;
import pro2e.userinterface.MyBorderFactory;
import pro2e.userinterface.Utility;

public class AntennaPicturePanelCircular
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TraceV1 trace = new TraceV1(this);
    private Image imgDipolZeileKreis = Utility.loadResourceImage("DipolZeileKreis.png");
    private Image imgDipolLinieKreis = Utility.loadResourceImage("DipolLinieKreis.png");
    private Image imgAusrichtung;
    private JLabel lbImage = new JLabel();

    public AntennaPicturePanelCircular() {
        super(new GridBagLayout());
        this.trace.constructorCall();
        this.setBorder(MyBorderFactory.createMyBorder(" Anordnung Kreis "));
        JPanel background = new JPanel(new GridBagLayout());
        background.setBackground(Color.WHITE);
        this.add((Component)background, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.imgAusrichtung = this.imgDipolZeileKreis;
        ImageIcon imageIcon = new ImageIcon(this.imgAusrichtung.getScaledInstance((int)DPIFixV3.screen.getWidth() / 3, (int)DPIFixV3.screen.getHeight() / 3, 4));
        this.lbImage = new JLabel(imageIcon, 0);
        background.add((Component)this.lbImage, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.lbImage.setToolTipText("R\u00e4umliche Anordnung der Strahler");
        this.setVisible(true);
    }

    private double getAspectRatio(Image im) {
        int width = im.getWidth(null);
        int height = im.getHeight(null);
        return (double)width / (double)height;
    }

    private double getAspectRatio(JLabel lb) {
        int width = lb.getWidth();
        int height = lb.getHeight();
        return (double)width / (double)height;
    }

    private ImageIcon resizedIcon() {
        double imageAspect = this.getAspectRatio(this.imgAusrichtung);
        double labelAspect = this.getAspectRatio(this.lbImage);
        int newWidth = 0;
        int newHeight = this.lbImage.getHeight();
        if (labelAspect < imageAspect) {
            newWidth = (int)((double)this.lbImage.getHeight() * labelAspect);
            newHeight = (int)((double)newWidth * (1.0 / imageAspect));
        } else {
            newWidth = (int)((double)this.lbImage.getHeight() * imageAspect);
        }
        ImageIcon imageIcon = new ImageIcon(this.imgAusrichtung.getScaledInstance(newWidth, newHeight, 4));
        return imageIcon;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.trace.methodeCall();
        super.paintComponent(g);
        this.lbImage.setIcon(this.resizedIcon());
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        int abstrahlung = model.getAntenna().getAbstrahlung();
        if (abstrahlung == 0) {
            this.imgAusrichtung = this.imgDipolZeileKreis;
        }
        if (abstrahlung == 3 || abstrahlung == 2) {
            this.imgAusrichtung = this.imgDipolLinieKreis;
        }
        this.repaint();
    }
}

