/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.input;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pro2e.DPIFixV3;
import pro2e.TraceV1;
import pro2e.controller.Controller;
import pro2e.model.Model;
import pro2e.userinterface.MyBorderFactory;
import pro2e.userinterface.input.AntennaInputPanel;
import pro2e.userinterface.input.PanelPlotLegende;
import pro2e.userinterface.input.PhasedArrayInputPanel;
import pro2e.userinterface.input.SidelobeInputPanel;
import pro2e.userinterface.plots.AntennaPicturePanelCircular;
import pro2e.userinterface.plots.PlotPanelAmplituden;

public class TabbedInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TraceV1 trace = new TraceV1(this);
    private Controller controller;
    private AntennaInputPanel antennaInputPanel;
    private PhasedArrayInputPanel phasedInputPanel;
    private SidelobeInputPanel sidelobeInputPanel;
    private PlotPanelAmplituden windowPlot = new PlotPanelAmplituden();
    private PanelPlotLegende legendePanel = new PanelPlotLegende();
    private JPanel panelAntennas = new JPanel(new GridBagLayout());
    private JPanel panelAdvanced = new JPanel(new GridBagLayout());
    private AntennaPicturePanelCircular kreisBild = new AntennaPicturePanelCircular();
    private JTabbedPane tabpane = new JTabbedPane(1, 1);

    public TabbedInputPanel(Controller controller) {
        super(new GridLayout());
        this.trace.constructorCall();
        this.controller = controller;
        this.antennaInputPanel = new AntennaInputPanel(controller);
        this.phasedInputPanel = new PhasedArrayInputPanel(controller);
        this.sidelobeInputPanel = new SidelobeInputPanel(controller);
        this.setMinimumSize(new Dimension(DPIFixV3.screen.width / 5, 0));
        this.setBorder(MyBorderFactory.createMyBorder(" Eingabe "));
        JLabel fillerA = new JLabel("");
        JLabel fillerB = new JLabel("");
        this.panelAntennas.add((Component)this.antennaInputPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panelAntennas.add((Component)this.phasedInputPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panelAntennas.add((Component)fillerA, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panelAntennas.add((Component)this.kreisBild, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.kreisBild.setVisible(false);
        this.panelAntennas.setMaximumSize(new Dimension(DPIFixV3.screen.width / 3, DPIFixV3.screen.height));
        this.panelAdvanced.add((Component)this.sidelobeInputPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panelAdvanced.add((Component)fillerB, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.windowPlot.setMinimumSize(new Dimension(DPIFixV3.screen.width / 6, DPIFixV3.screen.height / 6));
        this.panelAdvanced.add((Component)this.windowPlot, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panelAdvanced.add((Component)this.legendePanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tabpane.addTab("Antennen", this.panelAntennas);
        this.tabpane.addTab("Nebenkeulen", this.panelAdvanced);
        this.add(this.tabpane);
        this.setVisible(true);
    }

    public void valuesToController() {
        this.trace.methodeCall();
        this.antennaInputPanel.valuesToController();
        this.phasedInputPanel.valuesToController();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.trace.methodeCall();
        super.paintComponent(g);
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        this.antennaInputPanel.update(obs, obj);
        this.phasedInputPanel.update(obs, obj);
        this.sidelobeInputPanel.update(obs, obj);
        this.windowPlot.update(obs, obj);
        this.kreisBild.update(obs, obj);
        this.panelAdvanced.setEnabled(false);
        Model model = (Model)obs;
        this.tabpane.setEnabledAt(1, model.showLinearArrayOptions());
        this.kreisBild.setVisible(!model.showLinearArrayOptions());
    }
}

