/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.input;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pro2e.TraceV1;
import pro2e.controller.Controller;
import pro2e.model.Model;
import pro2e.userinterface.MyBorderFactory;
import pro2e.userinterface.StatusBar;
import pro2e.userinterface.input.JDoubleTextField;

public class SidelobeInputPanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener,
KeyListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private TraceV1 trace = new TraceV1(this);
    private Controller controller;
    private JRadioButton onSidelobe = new JRadioButton("On", false);
    private JRadioButton offSidelobe = new JRadioButton("Off", true);
    private ButtonGroup sidelobeOnOff = new ButtonGroup();
    private String[] windowTypeListe = new String[]{"Rechteck (keine)", "Dreieck", "Exponential", "Cosinus", "Cosinus-quadrat", "Dolph-Chebyshev", "Binomial"};
    private JComboBox<Object> selectWindow = new JComboBox<String>(this.windowTypeListe);
    private JLabel lbChebyAtten = new JLabel("D\u00e4mpfung dB");
    private JDoubleTextField tfChebyAtten = new JDoubleTextField("20.0", 1, false);
    private JSlider sliderCheby = new JSlider(0, 0, 60, 20);
    private JLabel lbCosAtten = new JLabel("Offset");
    private JDoubleTextField tfCosAtten = new JDoubleTextField("0.5", 1, false);
    private JSlider sliderCosin = new JSlider(0, 0, 100, 50);
    private JRadioButton onQuantize = new JRadioButton("On", false);
    private JRadioButton offQuantize = new JRadioButton("Off", true);
    private ButtonGroup quantizeOnOff = new ButtonGroup();
    private String[] bitrateListe = new String[]{"   2 Bit", "   3 Bit", "   4 Bit", "   5 Bit", "   8 Bit"};
    private JComboBox<Object> selectBitrate = new JComboBox<String>(this.bitrateListe);

    public SidelobeInputPanel(Controller controller) {
        super(new GridBagLayout());
        this.trace.constructorCall();
        this.controller = controller;
        this.setBorder(MyBorderFactory.createMyBorder(" Nebenkeulen "));
        this.add((Component)new JLabel("Unterdr\u00fcckung"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.onSidelobe, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.offSidelobe, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("Fensterfunktion"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.selectWindow, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.selectWindow.setEnabled(false);
        this.selectWindow.addActionListener(this);
        this.sidelobeOnOff.add(this.onSidelobe);
        this.sidelobeOnOff.add(this.offSidelobe);
        this.offSidelobe.addItemListener(this);
        this.add((Component)this.lbChebyAtten, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lbCosAtten, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.lbChebyAtten.setVisible(false);
        this.lbCosAtten.setVisible(false);
        this.add((Component)this.tfChebyAtten, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tfCosAtten, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tfChebyAtten.setEnabled(false);
        this.tfCosAtten.setEnabled(false);
        this.tfChebyAtten.setVisible(false);
        this.tfCosAtten.setVisible(false);
        this.add((Component)this.sliderCheby, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.sliderCheby.setMajorTickSpacing(10);
        this.sliderCheby.setMinorTickSpacing(2);
        this.sliderCheby.setPaintTicks(true);
        this.sliderCheby.setPaintLabels(true);
        this.sliderCheby.addChangeListener(this);
        this.sliderCheby.addMouseWheelListener(this);
        this.sliderCheby.setEnabled(false);
        this.sliderCheby.setVisible(false);
        this.add((Component)this.sliderCosin, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.sliderCosin.setMinorTickSpacing(2);
        this.sliderCosin.setMinorTickSpacing(10);
        this.sliderCosin.setPaintTicks(true);
        this.sliderCosin.setPaintLabels(true);
        this.sliderCosin.addChangeListener(this);
        this.sliderCosin.addMouseWheelListener(this);
        this.sliderCosin.setEnabled(false);
        this.sliderCosin.setVisible(false);
        this.add((Component)new JLabel("Diskretisierung"), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.onQuantize, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.offQuantize, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("Wertebereich"), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.selectBitrate, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.onQuantize.setEnabled(false);
        this.offQuantize.setEnabled(false);
        this.selectBitrate.setEnabled(false);
        this.selectBitrate.addActionListener(this);
        this.quantizeOnOff.add(this.onQuantize);
        this.quantizeOnOff.add(this.offQuantize);
        this.offQuantize.addItemListener(this);
        this.tfChebyAtten.addKeyListener(this);
        this.tfCosAtten.addKeyListener(this);
        this.tfChebyAtten.addMouseWheelListener(this);
        this.tfCosAtten.addMouseWheelListener(this);
        this.tfCosAtten.setToolTipText("Parameter zum Anpassen der Fensterfunktion");
        this.selectBitrate.setToolTipText("Aufl\u00f6sung in Bit f\u00fcr die Diskretisierung");
        this.onQuantize.setToolTipText("Fensterfunktion auf einen wertdiskreten Bereich anpassen");
        this.offQuantize.setToolTipText("Diskretisierung ausschalten");
        this.onSidelobe.setToolTipText("Nebenkeulenunterdr\u00fcckung einschalten");
        this.offSidelobe.setToolTipText("Nebenkeulenunterdr\u00fcckung ausschalten");
        this.sliderCosin.setToolTipText(this.tfCosAtten.getToolTipText());
        this.selectWindow.setToolTipText("Fensterfunktion die auf die Amplituden der einzelnen Strahler angewendet wird");
        this.setVisible(true);
    }

    public void valuesToController() {
        this.trace.methodeCall();
        if (this.offSidelobe.isSelected()) {
            this.controller.setWindow(0);
        } else {
            double value = 0.0;
            int window = this.getSelectedWindow();
            if (window == 1 || window == 12) {
                if (!this.tfChebyAtten.getText().isEmpty()) {
                    value = Double.parseDouble(this.tfChebyAtten.getText());
                }
                this.sliderCheby.setValue((int)value);
            }
            if (!(window != 3 && window != 4 || this.tfCosAtten.getText().isEmpty())) {
                value = Double.parseDouble(this.tfCosAtten.getText());
            }
            this.controller.setWindowParam(window, value);
        }
    }

    private int getSelectedWindow() {
        int index = this.selectWindow.getSelectedIndex();
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 11;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        return 0;
    }

    private int getSelectedBits() {
        switch (this.selectBitrate.getSelectedIndex()) {
            case 0: {
                StatusBar.showStatus("Discretisation: 2 Bit");
                return 2;
            }
            case 1: {
                StatusBar.showStatus("Discretisation: 3 Bit");
                return 3;
            }
            case 2: {
                StatusBar.showStatus("Discretisation: 4 Bit");
                return 4;
            }
            case 3: {
                StatusBar.showStatus("Discretisation: 5 Bit");
                return 5;
            }
        }
        StatusBar.showStatus("Discretisation: 8 Bit");
        return 8;
    }

    private void visibilityHandler() {
        int window = this.getSelectedWindow();
        if (this.offQuantize.isSelected()) {
            this.selectBitrate.setEnabled(false);
        } else {
            this.selectBitrate.setEnabled(window != 0);
        }
        if (this.offSidelobe.isSelected()) {
            this.selectWindow.setEnabled(false);
            this.offQuantize.setEnabled(false);
            this.onQuantize.setEnabled(false);
            this.sliderCheby.setEnabled(false);
            this.sliderCosin.setEnabled(false);
            this.tfChebyAtten.setEnabled(false);
            this.tfCosAtten.setEditable(false);
            this.lbChebyAtten.setEnabled(false);
            this.lbCosAtten.setEnabled(false);
        } else {
            this.selectWindow.setEnabled(true);
            this.offQuantize.setEnabled(window != 0);
            this.onQuantize.setEnabled(window != 0);
            this.sliderCheby.setEnabled(true);
            this.sliderCosin.setEnabled(true);
            this.tfChebyAtten.setEnabled(true);
            this.tfCosAtten.setEditable(true);
            this.lbChebyAtten.setEnabled(true);
            this.lbCosAtten.setEnabled(true);
        }
        if (window == 1 || window == 12) {
            this.lbChebyAtten.setVisible(true);
            this.tfChebyAtten.setVisible(true);
            this.sliderCheby.setVisible(true);
            if (window == 1) {
                this.tfChebyAtten.setToolTipText("D\u00e4mpfung aller Nebenkeulen in dB");
                this.sliderCheby.setToolTipText(this.tfChebyAtten.getToolTipText());
            } else {
                this.tfChebyAtten.setToolTipText("Ver\u00e4ndert die Steigung der Fensterfunktion");
                this.sliderCheby.setToolTipText(this.tfChebyAtten.getToolTipText());
            }
        } else {
            this.lbChebyAtten.setVisible(false);
            this.tfChebyAtten.setVisible(false);
            this.sliderCheby.setVisible(false);
        }
        if (window == 3 || window == 4) {
            this.lbCosAtten.setVisible(true);
            this.tfCosAtten.setVisible(true);
            this.tfCosAtten.setEnabled(true);
            this.sliderCosin.setVisible(true);
        } else {
            this.lbCosAtten.setVisible(false);
            this.tfCosAtten.setVisible(false);
            this.tfCosAtten.setEnabled(false);
            this.sliderCosin.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.trace.methodeCall();
        super.paintComponent(g);
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        if (this.getSelectedWindow() == 3 || this.getSelectedWindow() == 4) {
            this.tfCosAtten.setText(Double.toString(model.getWindowParam()));
        } else {
            this.sliderCheby.setValue((int)model.getWindowParam());
            this.tfChebyAtten.setText(Double.toString(model.getWindowParam()));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.trace.methodeCall();
        if (e.getKeyCode() == 10) {
            this.valuesToController();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        double value;
        this.trace.methodeCall();
        int window = this.getSelectedWindow();
        if (window == 1 || window == 12) {
            value = this.sliderCheby.getValue();
            this.controller.setWindowParam(window, value);
            this.tfChebyAtten.setText(Double.toString(value));
        }
        if ((window == 3 || window == 4) && (value = (double)this.sliderCosin.getValue()) != 56.0) {
            this.controller.setWindowParam(window, value /= 100.0);
            this.tfCosAtten.setText(Double.toString(value));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.trace.methodeCall();
        Object source = e.getSource();
        if (source == this.offSidelobe) {
            if (this.offSidelobe.isSelected()) {
                StatusBar.showStatus("Sidelobe surpression: OFF");
                this.controller.setWindow(0);
            } else {
                StatusBar.showStatus("Sidelobe surpression: ON");
            }
        }
        if (source == this.offQuantize) {
            if (this.offQuantize.isSelected()) {
                StatusBar.showStatus("Discretisation: OFF");
                this.controller.setDiskretisierung(false);
            } else {
                StatusBar.showStatus("Discretisation: ON");
                this.controller.setDiskretisierung(true, this.getSelectedBits());
                StatusBar.showStatus("Bitrange: " + this.getSelectedBits());
            }
        }
        this.visibilityHandler();
        this.valuesToController();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.trace.methodeCall();
        Object source = e.getSource();
        if (source == this.selectWindow) {
            int window = this.getSelectedWindow();
            switch (window) {
                case 0: {
                    StatusBar.showStatus("Window: rectangular");
                    this.controller.setWindow(0);
                    break;
                }
                case 11: {
                    StatusBar.showStatus("Window: triangular");
                    this.controller.setWindow(11);
                    break;
                }
                case 12: {
                    StatusBar.showStatus("Window: exponential");
                    this.controller.setWindowParam(12, 20.0);
                    this.lbChebyAtten.setText("Steigung");
                    break;
                }
                case 3: {
                    StatusBar.showStatus("Window: cosine");
                    this.controller.setWindowParam(3, 0.5);
                    this.sliderCosin.setValue(50);
                    break;
                }
                case 4: {
                    StatusBar.showStatus("Window: cosine square");
                    this.controller.setWindowParam(4, 0.5);
                    this.sliderCosin.setValue(50);
                    break;
                }
                case 1: {
                    StatusBar.showStatus("Window: chebyshev");
                    this.controller.setWindow(1);
                    this.tfChebyAtten.setText("20.0");
                    this.controller.setWindowParam(1, 20.0);
                    this.lbChebyAtten.setText("D\u00e4mpfung dB");
                    this.sliderCheby.setValue(20);
                    break;
                }
                case 2: {
                    StatusBar.showStatus("Window: binomial");
                    this.controller.setWindow(2);
                    break;
                }
                default: {
                    StatusBar.showStatus("Window: rectangular");
                    this.controller.setWindow(0);
                }
            }
        }
        if (source == this.selectBitrate) {
            this.controller.setDiskretisierung(true, this.getSelectedBits());
            StatusBar.showStatus("Bitrange: " + this.getSelectedBits());
        }
        this.visibilityHandler();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int newVal;
        this.trace.methodeCall();
        Object source = e.getSource();
        if (source == this.sliderCheby || source == this.tfChebyAtten) {
            if (e.getWheelRotation() > 0) {
                newVal = this.sliderCheby.getValue() - 1;
                if (newVal >= this.sliderCheby.getMinimum()) {
                    this.sliderCheby.setValue(newVal);
                } else {
                    this.sliderCheby.setValue(0);
                }
            } else {
                newVal = this.sliderCheby.getValue() + 1;
                if (newVal <= this.sliderCheby.getMaximum()) {
                    this.sliderCheby.setValue(newVal);
                } else {
                    this.sliderCheby.setValue(this.sliderCheby.getMaximum());
                }
            }
        }
        if (source == this.sliderCosin || source == this.tfCosAtten) {
            if (e.getWheelRotation() > 0) {
                newVal = this.sliderCosin.getValue() - 1;
                if (newVal >= this.sliderCosin.getMinimum()) {
                    this.sliderCosin.setValue(newVal);
                } else {
                    this.sliderCosin.setValue(0);
                }
            } else {
                newVal = this.sliderCosin.getValue() + 1;
                this.sliderCosin.setValue(newVal);
                if (newVal <= this.sliderCosin.getMaximum()) {
                    this.sliderCosin.setValue(newVal);
                } else {
                    this.sliderCosin.setValue(this.sliderCosin.getMaximum());
                }
            }
        }
    }
}

