/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.input;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pro2e.TraceV1;
import pro2e.controller.Controller;
import pro2e.model.Model;
import pro2e.userinterface.MyBorderFactory;
import pro2e.userinterface.StatusBar;
import pro2e.userinterface.input.JDoubleTextField;

public class PhasedArrayInputPanel
extends JPanel
implements KeyListener,
ItemListener,
ChangeListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private TraceV1 trace = new TraceV1(this);
    private Controller controller;
    private JRadioButton onPhase = new JRadioButton("On", false);
    private JRadioButton offPhase = new JRadioButton("Off", true);
    private ButtonGroup phaseOnOff;
    private JDoubleTextField tfPhaseDist = new JDoubleTextField("90", 1, false);
    private JSlider sliderPhase = new JSlider(0, 0, 180, 90);
    private JLabel lbPhase = new JLabel("Phase \u00b0");
    private JPanel pnPhasedArray = new JPanel(new GridBagLayout());

    public PhasedArrayInputPanel(Controller controller) {
        super(new GridBagLayout());
        this.trace.constructorCall();
        this.controller = controller;
        this.pnPhasedArray.setBorder(MyBorderFactory.createMyBorder(" Phased Array "));
        this.pnPhasedArray.add((Component)new JLabel("Phase"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnPhasedArray.add((Component)this.onPhase, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnPhasedArray.add((Component)this.offPhase, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.phaseOnOff = new ButtonGroup();
        this.phaseOnOff.add(this.onPhase);
        this.phaseOnOff.add(this.offPhase);
        this.onPhase.addItemListener(this);
        this.offPhase.addItemListener(this);
        this.pnPhasedArray.add((Component)this.lbPhase, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnPhasedArray.add((Component)this.tfPhaseDist, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.pnPhasedArray.add((Component)this.sliderPhase, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.sliderPhase.setMajorTickSpacing(45);
        this.sliderPhase.setMinorTickSpacing(5);
        this.sliderPhase.setPaintTicks(true);
        this.sliderPhase.setPaintLabels(true);
        this.sliderPhase.addChangeListener(this);
        this.sliderPhase.addMouseWheelListener(this);
        this.sliderPhase.setEnabled(false);
        this.tfPhaseDist.setEditable(false);
        this.tfPhaseDist.addKeyListener(this);
        this.tfPhaseDist.addMouseWheelListener(this);
        this.tfPhaseDist.setToolTipText("Abstrahlwinkel der Hauptkeule in Grad");
        this.onPhase.setToolTipText("Phase dazuschalten");
        this.offPhase.setToolTipText("Phase ausschalten");
        this.sliderPhase.setToolTipText(this.tfPhaseDist.getToolTipText());
        this.add((Component)this.pnPhasedArray, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setVisible(true);
    }

    public void valuesToController() {
        this.trace.methodeCall();
        double phase = 90.0;
        if (this.onPhase.isSelected() && !this.tfPhaseDist.getText().isEmpty()) {
            phase = Double.parseDouble(this.tfPhaseDist.getText());
        }
        this.controller.setPhase(phase);
        this.sliderPhase.setValue((int)phase);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.trace.methodeCall();
        super.paintComponent(g);
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        boolean show = model.showLinearArrayOptions();
        this.lbPhase.setEnabled(this.onPhase.isSelected());
        this.setVisible(show);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.trace.methodeCall();
        if (this.offPhase == e.getItem()) {
            StatusBar.showStatus("Phase off");
            this.controller.setPhase(90.0);
            this.tfPhaseDist.setEditable(false);
            this.sliderPhase.setEnabled(false);
        } else {
            StatusBar.showStatus("Phase on");
            this.tfPhaseDist.setEditable(true);
            this.sliderPhase.setEnabled(true);
            this.controller.setPhase(Double.parseDouble(this.tfPhaseDist.getText()));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.trace.methodeCall();
        if (e.getSource() == this.sliderPhase) {
            double phase = this.sliderPhase.getValue();
            this.controller.setPhase(180.0 - phase);
            this.tfPhaseDist.setText(Double.toString(phase));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.trace.methodeCall();
        if (e.getKeyCode() == 10) {
            this.valuesToController();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.trace.methodeCall();
        if (e.getWheelRotation() > 0) {
            int newVal = this.sliderPhase.getValue() - 1;
            if (newVal >= this.sliderPhase.getMinimum()) {
                this.sliderPhase.setValue(newVal);
            } else {
                this.sliderPhase.setValue(0);
            }
        } else {
            int newVal = this.sliderPhase.getValue() + 1;
            if (newVal <= this.sliderPhase.getMaximum()) {
                this.sliderPhase.setValue(newVal);
            } else {
                this.sliderPhase.setValue(this.sliderPhase.getMaximum());
            }
        }
    }
}

