/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.input;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JDoubleTextField
extends JTextField
implements FocusListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private boolean allowNegativeValues;
    private boolean mousePressed;

    public JDoubleTextField(String text, int columns, boolean allowNegativeValues) {
        super(text);
        this.setColumns(columns);
        this.allowNegativeValues = allowNegativeValues;
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    @Override
    protected Document createDefaultModel() {
        return new DoubleDocument(this);
    }

    public boolean getAllowNegativeValues() {
        return this.allowNegativeValues;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        new Thread(){

            @Override
            public void run() {
                while (JDoubleTextField.this.mousePressed) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                JDoubleTextField.this.selectAll();
            }
        }.start();
        this.selectAll();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireActionPerformed();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.mousePressed = false;
    }

    class DoubleDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private JDoubleTextField tf;

        public DoubleDocument(JDoubleTextField tf) {
            this.tf = tf;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            try {
                if (this.tf.allowNegativeValues) {
                    if (str.equals("-") || str.equals("+") || str.equals("e") || str.equals(".")) {
                        Double.parseDouble(String.valueOf(this.tf.getText()) + str + "0");
                    } else {
                        Double.parseDouble(String.valueOf(this.tf.getText()) + str);
                    }
                } else {
                    if (str.equals("-") && this.tf.getText().equals("")) {
                        return;
                    }
                    Double.parseDouble(String.valueOf(this.tf.getText()) + str + "0");
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

