/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface.input;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pro2e.TraceV1;
import pro2e.controller.Controller;
import pro2e.model.Model;
import pro2e.userinterface.MyBorderFactory;
import pro2e.userinterface.StatusBar;
import pro2e.userinterface.input.JDoubleTextField;

public class AntennaInputPanel
extends JPanel
implements ActionListener,
ItemListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private TraceV1 trace = new TraceV1(this);
    private Controller controller;
    private JDoubleTextField tfDLam = new JDoubleTextField("0.5", 1, false);
    private JDoubleTextField tfNAnt = new JDoubleTextField("8", 1, false);
    private String[] antennaTypeListe = new String[]{"Dipol Zeile", "hertzscher Dipol Linie", "\u03bb/2 Dipol Linie"};
    private JComboBox<Object> selectAntennaType = new JComboBox<String>(this.antennaTypeListe);
    private String[] reflektorPosListe = new String[]{"parallel", "senkrecht"};
    private JComboBox<Object> selectReflektorPos = new JComboBox<String>(this.reflektorPosListe);
    private String[] antennenGeometrieListe = new String[]{"linear", "Kreis"};
    private JComboBox<Object> selectGeometrie = new JComboBox<String>(this.antennenGeometrieListe);
    private JRadioButton onReflektor = new JRadioButton("On", false);
    private JRadioButton offReflektor = new JRadioButton("Off", true);
    private ButtonGroup reflektorOnOff;
    private JDoubleTextField tfReflDist = new JDoubleTextField("0.25", 1, false);
    private JLabel lbGeometrie = new JLabel("Arraygeometrie");
    private JLabel lbAntAbstand = new JLabel("Antennenabstand d/\u03bb");
    private JLabel lbRefAbstand = new JLabel("Reflektor Abstand  d/\u03bb");
    private JLabel lbNAnt = new JLabel("Anzahl Antennen");
    private JLabel lbAusrichtung = new JLabel("Ausrichtung");
    private JLabel lbReflektor = new JLabel("Reflektor");
    private JLabel lbPosition = new JLabel("Position");
    private JPanel pnAntenna = new JPanel(new GridBagLayout());
    private JPanel pnReflect = new JPanel(new GridBagLayout());

    public AntennaInputPanel(Controller controller) {
        super(new GridBagLayout());
        this.trace.constructorCall();
        this.controller = controller;
        this.pnAntenna.setBorder(MyBorderFactory.createMyBorder(" Antenne "));
        this.pnReflect.setBorder(MyBorderFactory.createMyBorder("Reflektor"));
        this.pnAntenna.add((Component)this.lbGeometrie, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnAntenna.add(this.selectGeometrie, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.pnAntenna.add((Component)this.lbAntAbstand, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnAntenna.add((Component)this.tfDLam, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.pnAntenna.add((Component)this.lbNAnt, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnAntenna.add((Component)this.tfNAnt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.pnAntenna.add((Component)this.lbAusrichtung, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnAntenna.add(this.selectAntennaType, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.pnReflect.add((Component)this.lbReflektor, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnReflect.add((Component)this.onReflektor, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnReflect.add((Component)this.offReflektor, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.reflektorOnOff = new ButtonGroup();
        this.reflektorOnOff.add(this.onReflektor);
        this.reflektorOnOff.add(this.offReflektor);
        this.onReflektor.addItemListener(this);
        this.offReflektor.addItemListener(this);
        this.pnReflect.add((Component)this.lbPosition, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnReflect.add(this.selectReflektorPos, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.selectReflektorPos.setEnabled(false);
        this.pnReflect.add((Component)this.lbRefAbstand, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnReflect.add((Component)this.tfReflDist, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tfReflDist.setEditable(false);
        this.tfDLam.addKeyListener(this);
        this.tfNAnt.addKeyListener(this);
        this.tfReflDist.addKeyListener(this);
        this.selectAntennaType.addActionListener(this);
        this.selectReflektorPos.addActionListener(this);
        this.selectGeometrie.addActionListener(this);
        this.selectGeometrie.setToolTipText("geometrische Anordnung der einzelnen Strahler");
        this.tfNAnt.setToolTipText("Anzahl der einzelnen Strahler");
        this.selectAntennaType.setToolTipText("Abstrahlungstyp eines einzelnen Strahlers");
        this.tfDLam.setToolTipText("Einheitsloses Verh\u00e4ltniss zwischen der Wellenl\u00e4nge und dem Abstand der einzelnen Strahler");
        this.tfNAnt.setToolTipText("Anzahl einzelner Strahler im Array");
        this.tfReflDist.setToolTipText("Einheitsloses Verh\u00e4ltniss zwischen der Wellenl\u00e4nge und dem Abstand des Reflektors zum Array");
        this.selectAntennaType.setToolTipText("2D Abstrahlcharakteristik eines einzelnen Strahlers");
        this.selectReflektorPos.setToolTipText("Position des Reflektors zum Array");
        this.onReflektor.setToolTipText("Reflektor hinzuf\u00fcgen");
        this.offReflektor.setToolTipText("Reflektor entfernen");
        this.lbAntAbstand.setToolTipText(this.tfDLam.getToolTipText());
        this.lbNAnt.setToolTipText(this.tfNAnt.getToolTipText());
        this.lbRefAbstand.setToolTipText(this.tfReflDist.getToolTipText());
        this.lbAusrichtung.setToolTipText(this.selectAntennaType.getToolTipText());
        this.lbPosition.setToolTipText(this.selectReflektorPos.getToolTipText());
        this.lbGeometrie.setToolTipText(this.selectGeometrie.getToolTipText());
        this.add((Component)this.pnAntenna, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.pnReflect, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setVisible(true);
    }

    private int getSelectedPosition() {
        int index = this.selectReflektorPos.getSelectedIndex();
        switch (index) {
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    public void valuesToController() {
        this.trace.methodeCall();
        int type = this.getSelectedAntenna();
        double dLam = 0.0;
        if (!this.tfDLam.getText().isEmpty()) {
            dLam = Double.parseDouble(this.tfDLam.getText());
        }
        int nAnt = 1;
        if (!this.tfNAnt.getText().isEmpty()) {
            nAnt = (int)Double.parseDouble(this.tfNAnt.getText());
        }
        double dLamRef = 0.25;
        if (!this.tfReflDist.getText().isEmpty()) {
            dLamRef = Double.parseDouble(this.tfReflDist.getText());
        }
        this.controller.setAntenna(this.selectGeometrie.getSelectedIndex(), dLam, nAnt, type, this.onReflektor.isSelected(), dLamRef, this.getSelectedPosition());
    }

    @Override
    public void paintComponent(Graphics g) {
        this.trace.methodeCall();
        super.paintComponent(g);
    }

    public void update(Observable obs, Object obj) {
        this.trace.methodeCall();
        Model model = (Model)obs;
        this.tfNAnt.setText(Integer.toString(model.getNAnt()));
        this.tfDLam.setText(Double.toString(model.getDLam()));
        this.tfReflDist.setText(Double.toString(model.getdLamReflektor()));
        boolean show = model.showLinearArrayOptions();
        this.onReflektor.setVisible(show);
        this.offReflektor.setVisible(show);
        this.selectReflektorPos.setVisible(show);
        this.tfReflDist.setVisible(show);
        this.lbReflektor.setVisible(show);
        this.lbRefAbstand.setVisible(show);
        this.lbPosition.setVisible(show);
        this.pnReflect.setVisible(show);
        if (show) {
            this.lbAntAbstand.setText("Antennenabstand d/\u03bb");
        } else {
            this.lbAntAbstand.setText("Radius r/\u03bb");
        }
    }

    private int getSelectedAntenna() {
        int type = this.selectAntennaType.getSelectedIndex();
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.trace.methodeCall();
        this.controller.setAntennaType(this.getSelectedAntenna());
        this.valuesToController();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.trace.methodeCall();
        if (this.offReflektor == e.getItem()) {
            StatusBar.showStatus("Reflektor off");
            this.tfReflDist.setEditable(false);
            this.selectReflektorPos.setEnabled(false);
        } else {
            StatusBar.showStatus("Reflektor on");
            this.tfReflDist.setEditable(true);
            this.selectReflektorPos.setEnabled(true);
        }
        this.valuesToController();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.trace.methodeCall();
        if (e.getKeyCode() == 10) {
            this.valuesToController();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

