/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pro2e.DonutFramework;
import pro2e.controller.Controller;
import pro2e.userinterface.input.TabbedInputPanel;
import pro2e.userinterface.plots.AntennaPicturePanel;
import pro2e.userinterface.plots.PlotPanelAmplituden;
import pro2e.userinterface.plots.TabbedPlotPanel;

public class TopView
extends JPanel
implements Observer,
ActionListener {
    private static final long serialVersionUID = 1L;
    private TabbedPlotPanel plotPanel = new TabbedPlotPanel();
    private TabbedInputPanel inputPanel;
    private PlotPanelAmplituden plotAmplituden = new PlotPanelAmplituden();
    private AntennaPicturePanel picturePanel = new AntennaPicturePanel();
    private JButton btReset = new JButton("Reset Plot-Achsen");
    private JButton btScale = new JButton("lineare Skala");
    private JLabel lb3db = new JLabel("0");
    private JPanel containerPlots = new JPanel(new GridBagLayout());
    private JPanel containerInput = new JPanel(new GridBagLayout());
    private boolean plotScaleDb = true;
    private Controller controller;

    public TopView(Controller controller) {
        super(new GridBagLayout());
        this.controller = controller;
        this.inputPanel = new TabbedInputPanel(this.controller);
        UIManager.put("TabbedPane.selected", DonutFramework.Colors.Pink);
        UIManager.put("TabbedPane.background", Color.LIGHT_GRAY);
        UIManager.put("TabbedPane.foreground", Color.WHITE);
        UIManager.put("Button.background", DonutFramework.Colors.Blue);
        UIManager.put("Button.foreground", Color.WHITE);
        UIManager.put("MenuBar.background", DonutFramework.Colors.Beige);
        UIManager.put("MenuBar.foreground", Color.DARK_GRAY);
        UIManager.put("TabbedPane.borderHightlightColor", Color.LIGHT_GRAY);
        this.containerInput.add((Component)this.inputPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.containerPlots.add((Component)this.plotPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.containerPlots.add((Component)this.btScale, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.containerPlots.add((Component)this.btReset, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.containerPlots.add((Component)this.picturePanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.containerInput, new GridBagConstraints(0, 0, 1, 1, 0.3, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.containerPlots, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.btReset.setToolTipText("Setzt die Achsenskalierung aller Plots auf den Ursprungswert zur\u00fcck");
        this.btScale.setToolTipText("Skala \u00e4ndern");
        this.btReset.addActionListener(this);
        this.btScale.addActionListener(this);
    }

    @Override
    public void update(Observable obs, Object obj) {
        this.plotPanel.update(obs, obj);
        this.picturePanel.update(obs, obj);
        this.inputPanel.update(obs, obj);
        this.plotAmplituden.update(obs, obj);
        this.lb3db.setText(String.valueOf(String.format("%.2f", this.plotPanel.get3dbAngle(obs, obj))) + "\u00b0");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            this.inputPanel.valuesToController();
        } else {
            if (e.getSource() == this.btReset) {
                this.plotPanel.resetAxis(this.plotScaleDb);
                this.plotAmplituden.resetAxis();
                this.inputPanel.valuesToController();
            }
            if (e.getSource() == this.btScale) {
                boolean bl = this.plotScaleDb = !this.plotScaleDb;
                if (this.plotScaleDb) {
                    this.btScale.setText("lineare Skala     ");
                } else {
                    this.btScale.setText("logarithmische Skala");
                }
                this.controller.setPlotScaleDb(this.plotScaleDb);
                this.plotPanel.resetAxis(this.plotScaleDb);
                this.inputPanel.valuesToController();
            }
        }
    }
}

