/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pro2e.userinterface.MyBorderFactory;

public class StatusBar
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static JTextArea textArea = new JTextArea(5, 50);
    private static JPopupMenu popup = new JPopupMenu();
    private static JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem("Append", true);

    public StatusBar() {
        this.setBorder(MyBorderFactory.createMyBorder(" StatusBar "));
        textArea.setEditable(false);
        textArea.setBackground(Color.BLACK);
        textArea.setForeground(Color.WHITE);
        cbMenuItem.setMnemonic(67);
        popup.add(cbMenuItem);
        popup.addSeparator();
        JMenuItem menuItem = new JMenuItem("Clear Status");
        menuItem.setActionCommand("clear");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        textArea.addMouseListener(popupListener);
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
        this.setMinimumSize(new Dimension((int)this.getPreferredSize().getWidth(), (int)this.getPreferredSize().getHeight()));
    }

    public static void showStatus(String text) {
        if (cbMenuItem.getState()) {
            textArea.setText(String.valueOf(textArea.getText()) + "\n" + text);
        } else {
            textArea.setText(text);
        }
    }

    public static void showStatus(EventObject e, String text) {
        if (cbMenuItem.getState()) {
            textArea.setText(String.valueOf(textArea.getText()) + "\n" + e.getSource().getClass().getSimpleName() + ": " + text);
        } else {
            textArea.setText(String.valueOf(e.getSource().getClass().getSimpleName()) + ": " + text);
        }
    }

    public static void showStatus(Object o, EventObject e, String text) {
        if (cbMenuItem.getState()) {
            textArea.setText(String.valueOf(textArea.getText()) + "\n" + o.getClass() + ": Command \"" + text + "\" fired by " + e.getSource().getClass().getSimpleName());
        } else {
            textArea.setText(o.getClass() + ": Command \"" + text + "\" fired by " + e.getSource().getClass().getSimpleName());
        }
    }

    public static void clear() {
        textArea.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("clear")) {
            textArea.setText("");
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

