/*
 * Decompiled with CFR 0.152.
 */
package pro2e.userinterface;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pro2e.DonutFramework;
import pro2e.controller.Controller;

public class MenuBar
extends JMenuBar
implements Observer,
ActionListener {
    private static final long serialVersionUID = 1L;
    JMenu tutorialMenu;
    JMenu help;
    JMenuItem showTutorial = new JMenuItem("Tutorial anzeigen");
    JMenuItem showAbout = new JMenuItem("About");
    JCheckBoxMenuItem checkTutorialStartup = new JCheckBoxMenuItem("beim aufstarten anzeigen");
    DonutFramework frame;
    Controller controller;

    public MenuBar(Controller controller, DonutFramework frame) {
        this.frame = frame;
        this.controller = controller;
        this.help = new JMenu("Hilfe");
        this.help.setMnemonic(72);
        this.tutorialMenu = new JMenu("Tutorial");
        this.tutorialMenu.setMnemonic(84);
        this.tutorialMenu.add(this.showTutorial);
        this.tutorialMenu.add(this.checkTutorialStartup);
        this.checkTutorialStartup.setSelected(frame.getShowOnStartup());
        this.help.add(this.tutorialMenu);
        this.help.add(this.showAbout);
        this.showAbout.addActionListener(this);
        this.showTutorial.addActionListener(this);
        this.checkTutorialStartup.addActionListener(this);
        this.add(this.help);
    }

    @Override
    public void update(Observable o, Object obj) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.showAbout) {
            BufferedImage logo = null;
            try {
                logo = ImageIO.read(DonutFramework.class.getResourceAsStream("Icon.png"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ImageIcon logoIcon = new ImageIcon(logo);
            Object[] message = new Object[]{"Willkommen beim Donut Antennentool", logoIcon, "Projektleiter:", "- Dagelet Patrice", new JLabel(), "Programmierer:", "- Burkhardt Simon", "- Stadlin Christian", new JLabel(), "Mathematiker:", "- Enderlin Stefan", "- Studer Mischa", "- Frey Fabian", "- L\u00e4derach Reto", new JLabel(), "(c) 2018 - Fachhochschule Nordwestschweiz"};
            JOptionPane aboutDialog = new JOptionPane(message, -1);
            JDialog dialog = aboutDialog.createDialog(null, "About");
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            dialog.setLocation(screenSize.width / 3, screenSize.height / 3);
            dialog.setVisible(true);
        }
        if (source == this.showTutorial) {
            this.frame.showTutorial();
        }
        if (source == this.checkTutorialStartup) {
            this.frame.setShowOnStartup(this.checkTutorialStartup.isSelected());
            System.out.println(this.checkTutorialStartup.isSelected());
        }
    }
}

