/*
 * Decompiled with CFR 0.152.
 */
package pro2e.model;

import java.util.Observable;
import pro2e.TraceV1;
import pro2e.model.Antenna;
import pro2e.model.CircularAntennaArray;
import pro2e.model.LinearAntennaArray;

public class Model
extends Observable {
    private TraceV1 trace = new TraceV1(this);
    private Antenna antenna = new Antenna(0, 1);
    private LinearAntennaArray antArray = new LinearAntennaArray(this.antenna);
    private CircularAntennaArray cirleArray = new CircularAntennaArray(this.antenna);
    private Object activeArray = this.antArray;

    public boolean isPlotScaleDb() {
        return this.antArray.isPlotScaleDb();
    }

    public void setPlotScaleDb(boolean plotScaleDb) {
        this.cirleArray.setPlotScaleDb(plotScaleDb);
        this.antArray.setPlotScaleDb(plotScaleDb);
    }

    public boolean showLinearArrayOptions() {
        return this.activeArray == this.antArray;
    }

    public double[] getPlot() {
        if (this.activeArray == this.antArray) {
            return this.antArray.getLinearPhasedArrayPlot();
        }
        return this.cirleArray.getCircularArrayPlot();
    }

    public Model() {
        this.trace.constructorCall();
    }

    public int getnMeasures() {
        this.trace.methodeCall();
        return this.antArray.getnMeasures();
    }

    public void setnMeasures(int nMeasures) {
        this.trace.methodeCall();
        this.antArray.setnMeasures(nMeasures);
        this.cirleArray.setnMeasures(nMeasures);
    }

    public int getnBits() {
        this.trace.methodeCall();
        return this.antArray.getnBits();
    }

    public void setnBits(int nBits) {
        this.trace.methodeCall();
        this.antArray.setnBits(nBits);
    }

    public boolean isDiskretisierung() {
        this.trace.methodeCall();
        return this.antArray.isDiskretisierung();
    }

    public void setDiskretisierung(boolean diskretisierung) {
        this.trace.methodeCall();
        this.antArray.setDiskretisierung(diskretisierung);
        this.notifyObservers();
    }

    public void setDiskretisierung(boolean diskretisierung, int nBits) {
        this.trace.methodeCall();
        this.antArray.setDiskretisierung(diskretisierung);
        this.antArray.setnBits(nBits);
        this.notifyObservers();
    }

    public void setAntenna(int geo, double dLam, int nAnt, int type, boolean reflektor, double dLamRef, int refPos) {
        this.trace.methodeCall();
        this.cirleArray.setnAnt(nAnt);
        this.cirleArray.getAntenne().setAbstrahlung(type);
        this.cirleArray.setdLamRadius(dLam);
        this.antArray.setdLam(dLam);
        this.antArray.setnAnt(nAnt);
        this.antArray.getAntenne().setAbstrahlung(type);
        this.antArray.setReflektor(reflektor);
        this.antArray.setdLamReflektor(dLamRef);
        this.antArray.setReflektorPosition(refPos);
        if (geo == 0) {
            this.activeArray = this.antArray;
        }
        if (geo == 1) {
            this.activeArray = this.cirleArray;
        }
        this.notifyObservers();
    }

    public boolean isReflektor() {
        this.trace.methodeCall();
        return this.antArray.isReflektor();
    }

    public void setReflektor(boolean reflektor) {
        this.trace.methodeCall();
        this.antArray.setReflektor(reflektor);
    }

    public double getdLamReflektor() {
        this.trace.methodeCall();
        return this.antArray.getdLamReflektor();
    }

    public void setdLamReflektor(double dLamReflektor) {
        this.trace.methodeCall();
        this.antArray.setdLamReflektor(dLamReflektor);
    }

    public int getWindow() {
        this.trace.methodeCall();
        return this.antArray.getWindow();
    }

    public void setWindow(int window) {
        this.trace.methodeCall();
        this.antArray.setWindow(window);
        this.notifyObservers();
    }

    public double getWindowParam() {
        this.trace.methodeCall();
        return this.antArray.getWindowParam();
    }

    public void setWindowParam(double windowParam) {
        this.trace.methodeCall();
        this.antArray.setWindowParam(windowParam);
        this.notifyObservers();
    }

    public void setWindowParam(int window, double windowParam) {
        this.trace.methodeCall();
        this.antArray.setWindow(window);
        this.antArray.setWindowParam(windowParam);
        this.notifyObservers();
    }

    public double getPhase() {
        this.trace.methodeCall();
        return this.antArray.getPhase();
    }

    public void setPhase(double phase) {
        this.trace.methodeCall();
        this.antArray.setPhase(phase);
        this.notifyObservers();
    }

    public Antenna getAntenna() {
        this.trace.methodeCall();
        return this.antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.trace.methodeCall();
        this.antenna = antenna;
        this.notifyObservers();
    }

    public LinearAntennaArray getAntArray() {
        this.trace.methodeCall();
        return this.antArray;
    }

    public void setAntArray(LinearAntennaArray antArray) {
        this.trace.methodeCall();
        this.antArray = antArray;
        this.notifyObservers();
    }

    public double getDLam() {
        this.trace.methodeCall();
        return this.antArray.getdLam();
    }

    public void setDLam(double dLam) {
        this.trace.methodeCall();
        this.antArray.setdLam(dLam);
        this.notifyObservers();
    }

    public void setAntennaType(int t) {
        this.trace.methodeCall();
        this.antenna.setAbstrahlung(t);
        this.notifyObservers();
    }

    @Override
    public void notifyObservers() {
        this.trace.methodeCall();
        this.setChanged();
        super.notifyObservers();
    }

    public void setNAnt(int nAnt) {
        this.trace.methodeCall();
        this.antArray.setnAnt(nAnt);
        this.notifyObservers();
    }

    public int getNAnt() {
        this.trace.methodeCall();
        return this.antArray.getnAnt();
    }
}

