/*
 * Decompiled with CFR 0.152.
 */
package pro2e.model;

import org.apache.commons.math3.complex.Complex;
import pro2e.matlabfunctions.Fensterfunktionen;
import pro2e.matlabfunctions.MiniMatlab;
import pro2e.model.Antenna;

public class LinearAntennaArray {
    public static final int POSITION_BROADSIDE = 0;
    public static final int POSITION_ENDFIRE = 1;
    private int nAnt = 8;
    private double dLam = 0.5;
    private double phase = 90.0;
    private int window = 0;
    private double windowParam = 0.9;
    private boolean reflektor = false;
    private double dLamReflektor = 0.5;
    private int nMeasures = 361;
    private int nBits = 3;
    private boolean diskretisierung = false;
    private int reflektorPosition = 0;
    private boolean plotScaleDb = true;
    private Antenna antenne;

    public double get3dbAngle() {
        int indexOfMainLobe;
        int resolution = 1000;
        double degreesPerStep = 360.0 / (double)resolution;
        int nMeas = this.nMeasures;
        this.nMeasures = resolution;
        double[] pattern = this.getLinearPhasedArrayPlot();
        this.nMeasures = nMeas;
        double db3 = 3.0;
        int indexOfRight3db = indexOfMainLobe = MiniMatlab.getIndexOfMax(pattern);
        int indexOfLeft3db = indexOfMainLobe;
        double max = pattern[indexOfMainLobe];
        int i = indexOfMainLobe;
        while (i < pattern.length) {
            if (MiniMatlab.abs(max - pattern[i]) >= db3) {
                indexOfRight3db = i;
                i = pattern.length;
            }
            ++i;
        }
        i = indexOfMainLobe;
        while (i > 0) {
            if (MiniMatlab.abs(max - pattern[i]) >= db3) {
                indexOfLeft3db = i;
                i = 0;
            }
            --i;
        }
        return MiniMatlab.abs(degreesPerStep * (double)indexOfLeft3db - degreesPerStep * (double)indexOfRight3db);
    }

    public double[] getLinearPhasedArrayPlot() {
        double[] out = new double[this.nMeasures];
        double[] psi_r = MiniMatlab.linspace(0.0, Math.PI * 2, this.nMeasures);
        this.phase = 0.0 - this.phase;
        double dd_pp = Math.PI * 2 * Math.cos(Math.toRadians(this.phase)) * this.dLam;
        double[] ak = new double[this.nMeasures];
        switch (this.window) {
            case 1: {
                ak = Fensterfunktionen.Chebwin(this.nAnt, this.windowParam);
                break;
            }
            case 11: {
                ak = Fensterfunktionen.Triangular(this.nAnt);
                break;
            }
            case 2: {
                ak = Fensterfunktionen.Binominal(this.nAnt);
                break;
            }
            case 3: {
                ak = Fensterfunktionen.Cosin(this.nAnt, this.windowParam);
                break;
            }
            case 4: {
                ak = Fensterfunktionen.CosinSquare(this.nAnt, this.windowParam);
                break;
            }
            case 12: {
                ak = Fensterfunktionen.Exponential(this.nAnt, this.windowParam);
                break;
            }
            default: {
                ak = Fensterfunktionen.Rectangular(this.nAnt);
            }
        }
        if (this.isDiskretisierung()) {
            ak = Fensterfunktionen.Quantize(ak, this.getnBits());
        }
        double[] amplitude = this.antenne.getIntensity(this.nMeasures);
        double[] pk = new double[this.nAnt];
        int i = 0;
        while (i < pk.length) {
            pk[i] = (double)(i + 1) * dd_pp;
            ++i;
        }
        Complex[] s = new Complex[this.nMeasures];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = new Complex(0.0, 0.0);
            ++i2;
        }
        double phi = 0.0;
        if (this.isReflektor()) {
            if (this.reflektorPosition == 1) {
                int ii = 0;
                while (ii < this.nMeasures) {
                    if (psi_r[ii] >= 1.5707963267948966 && psi_r[ii] <= 4.71238898038469) {
                        int k = 0;
                        while (k < this.nAnt) {
                            phi = -(this.dLam * 2.0 * Math.PI * Math.cos(psi_r[ii]) * (double)k + pk[k]);
                            Complex addend = new Complex(Math.cos(phi), Math.sin(phi));
                            addend = addend.multiply(ak[k]).multiply(amplitude[ii]);
                            s[ii] = s[ii].add(addend);
                            phi = -((2.0 * this.dLamReflektor + this.dLam * (double)k) * 2.0 * Math.PI * Math.cos(psi_r[ii]) + this.dLam * 2.0 * Math.PI * Math.cos(psi_r[ii]) * (double)k + pk[k] + Math.PI);
                            if (this.antenne.getAbstrahlung() != 0) {
                                phi -= Math.PI;
                            }
                            addend = new Complex(Math.cos(phi), Math.sin(phi));
                            addend = addend.multiply(ak[k]).multiply(amplitude[ii]);
                            s[ii] = s[ii].add(addend);
                            ++k;
                        }
                    } else {
                        s[ii] = new Complex(0.0, 0.0);
                    }
                    ++ii;
                }
            } else {
                int ii = 0;
                while (ii < this.nMeasures) {
                    if (psi_r[ii] >= 0.0 && psi_r[ii] <= Math.PI) {
                        int k = 0;
                        while (k < this.nAnt) {
                            phi = -(this.dLam * 2.0 * Math.PI * Math.cos(psi_r[ii]) * (double)k + pk[k]);
                            Complex addend = new Complex(Math.cos(phi), Math.sin(phi));
                            addend = addend.multiply(ak[k]).multiply(amplitude[ii]);
                            s[ii] = s[ii].add(addend);
                            phi = -(2.0 * this.dLamReflektor * 2.0 * Math.PI * Math.sin(psi_r[ii]) + this.dLam * 2.0 * Math.PI * Math.cos(psi_r[ii]) * (double)k + Math.PI + pk[k]);
                            addend = new Complex(Math.cos(phi), Math.sin(phi));
                            addend = addend.multiply(ak[k]).multiply(amplitude[ii]);
                            s[ii] = s[ii].add(addend);
                            ++k;
                        }
                    } else {
                        s[ii] = new Complex(0.0, 0.0);
                    }
                    ++ii;
                }
            }
        } else {
            int ii = 0;
            while (ii < this.nMeasures) {
                int k = 0;
                while (k < this.nAnt) {
                    phi = -(this.dLam * 2.0 * Math.PI * Math.cos(psi_r[ii]) * (double)k + pk[k]);
                    Complex addend = new Complex(Math.cos(phi), Math.sin(phi));
                    addend = addend.multiply(ak[k]);
                    addend = addend.multiply(amplitude[ii]);
                    s[ii] = s[ii].add(addend);
                    ++k;
                }
                ++ii;
            }
        }
        out = this.plotScaleDb ? MiniMatlab.db20(MiniMatlab.normalize(MiniMatlab.abs(s))) : MiniMatlab.normalize(MiniMatlab.abs(s));
        return out;
    }

    public boolean isPlotScaleDb() {
        return this.plotScaleDb;
    }

    public void setPlotScaleDb(boolean plotScaleDb) {
        this.plotScaleDb = plotScaleDb;
    }

    public int getReflektorPosition() {
        return this.reflektorPosition;
    }

    public void setReflektorPosition(int reflektorPosition) {
        this.reflektorPosition = reflektorPosition;
    }

    public int getnBits() {
        return this.nBits;
    }

    public void setnBits(int nBits) {
        this.nBits = nBits;
    }

    public boolean isDiskretisierung() {
        return this.diskretisierung;
    }

    public void setDiskretisierung(boolean diskretisierung) {
        this.diskretisierung = diskretisierung;
    }

    public int getnMeasures() {
        return this.nMeasures;
    }

    public void setnMeasures(int nMeasures) {
        this.nMeasures = nMeasures;
    }

    public int getnAnt() {
        return this.nAnt;
    }

    public void setnAnt(int nAnt) {
        this.nAnt = nAnt;
    }

    public double getdLam() {
        return this.dLam;
    }

    public void setdLam(double dLam) {
        this.dLam = dLam;
    }

    public double getPhase() {
        return this.phase;
    }

    public void setPhase(double phase) {
        this.phase = phase;
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int window) {
        this.window = window;
    }

    public double getWindowParam() {
        return this.windowParam;
    }

    public void setWindowParam(double windowParam) {
        this.windowParam = windowParam;
    }

    public boolean isReflektor() {
        return this.reflektor;
    }

    public void setReflektor(boolean reflektor) {
        this.reflektor = reflektor;
    }

    public double getdLamReflektor() {
        return this.dLamReflektor;
    }

    public void setdLamReflektor(double dLamReflektor) {
        this.dLamReflektor = dLamReflektor;
    }

    public Antenna getAntenne() {
        return this.antenne;
    }

    public void setAntenne(Antenna antenne) {
        this.antenne = antenne;
    }

    public LinearAntennaArray(Antenna ant) {
        this.antenne = ant;
    }
}

