/*
 * Decompiled with CFR 0.152.
 */
package pro2e.model;

import org.apache.commons.math3.complex.Complex;
import pro2e.matlabfunctions.MiniMatlab;
import pro2e.model.Antenna;

public class CircularAntennaArray {
    private int nAnt = 8;
    private double dLamRadius = 0.5;
    private int nMeasures = 361;
    private boolean plotScaleDb = true;
    private Antenna antenne;

    public double get3dbAngle() {
        int indexOfMainLobe;
        int resolution = 1000;
        double degreesPerStep = 360.0 / (double)resolution;
        int nMeas = this.nMeasures;
        this.nMeasures = resolution;
        double[] pattern = this.getCircularArrayPlot();
        this.nMeasures = nMeas;
        double db3 = 3.0;
        int indexOfRight3db = indexOfMainLobe = MiniMatlab.getIndexOfMax(pattern);
        int indexOfLeft3db = indexOfMainLobe;
        double max = pattern[indexOfMainLobe];
        int i = indexOfMainLobe;
        while (i < pattern.length) {
            if (MiniMatlab.abs(max - pattern[i]) >= db3) {
                indexOfRight3db = i;
                i = pattern.length;
            }
            ++i;
        }
        i = indexOfMainLobe;
        while (i > 0) {
            if (MiniMatlab.abs(max - pattern[i]) >= db3) {
                indexOfLeft3db = i;
                i = 0;
            }
            --i;
        }
        return MiniMatlab.abs(degreesPerStep * (double)indexOfLeft3db - degreesPerStep * (double)indexOfRight3db);
    }

    public double[] getCircularArrayPlot() {
        double[] out = new double[this.nMeasures];
        double[] psi_r = MiniMatlab.linspace(0.0, Math.PI * 2, this.nMeasures);
        double[] amplitude = this.antenne.getIntensity(this.nMeasures);
        Complex[] s = new Complex[this.nMeasures];
        int i = 0;
        while (i < s.length) {
            s[i] = new Complex(0.0, 0.0);
            ++i;
        }
        double phi = 0.0;
        double alp = Math.PI * 2 / (double)this.nAnt;
        int ii = 0;
        while (ii < this.nMeasures) {
            int k = 0;
            while (k < this.nAnt) {
                phi = -(this.dLamRadius * 4.0 * Math.PI * Math.cos(psi_r[ii] - (double)k * (alp / 2.0)) * Math.sin((double)k * (alp / 2.0)));
                Complex addend = new Complex(Math.cos(phi), Math.sin(phi));
                addend = addend.multiply(amplitude[ii]);
                s[(ii + this.nMeasures * 25) % this.nMeasures] = s[ii].add(addend);
                ++k;
            }
            ++ii;
        }
        out = this.plotScaleDb ? MiniMatlab.db20(MiniMatlab.normalize(MiniMatlab.abs(s))) : MiniMatlab.normalize(MiniMatlab.abs(s));
        return out;
    }

    public boolean isPlotScaleDb() {
        return this.plotScaleDb;
    }

    public void setPlotScaleDb(boolean plotScaleDb) {
        this.plotScaleDb = plotScaleDb;
    }

    public double getdLamRadius() {
        return this.dLamRadius;
    }

    public void setdLamRadius(double dLamRadius) {
        this.dLamRadius = dLamRadius;
    }

    public int getnMeasures() {
        return this.nMeasures;
    }

    public void setnMeasures(int nMeasures) {
        this.nMeasures = nMeasures;
    }

    public int getnAnt() {
        return this.nAnt;
    }

    public void setnAnt(int nAnt) {
        this.nAnt = nAnt;
    }

    public Antenna getAntenne() {
        return this.antenne;
    }

    public void setAntenne(Antenna antenne) {
        this.antenne = antenne;
    }

    public CircularAntennaArray(Antenna ant) {
        this.antenne = ant;
    }
}

