/*
 * Decompiled with CFR 0.152.
 */
package pro2e.matlabfunctions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;

public class MiniMatlab {
    static final FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.STANDARD);
    static final SplineInterpolator interpolator = new SplineInterpolator();

    public static int nchoosek(int n, int k) {
        return MiniMatlab.factorial(n) / (MiniMatlab.factorial(k) * MiniMatlab.factorial(n - k));
    }

    public static BigDecimal nchoosekBig(int n, int k) {
        return MiniMatlab.factorialBig(n).divide(MiniMatlab.factorialBig(k).multiply(MiniMatlab.factorialBig(n - k)));
    }

    public static int getIndexOfMax(double[] a) {
        int index = 0;
        double max = 0.0;
        int i = 0;
        while (i < a.length) {
            if (a[i] >= max) {
                max = a[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static double[] db20(double[] a) {
        int i = 0;
        while (i < a.length) {
            a[i] = 20.0 * Math.log10(a[i]);
            if (!Double.isFinite(a[i])) {
                a[i] = Double.NaN;
            }
            ++i;
        }
        return a;
    }

    public static double sum(double[] a) {
        double sum = 0.0;
        int ii = 0;
        while (ii < a.length) {
            sum += a[ii];
            ++ii;
        }
        return sum;
    }

    public static double[] abs(Complex[] z) {
        double[] ret = new double[z.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = z[i].abs();
            ++i;
        }
        return ret;
    }

    public static double abs(double a) {
        if (a >= 0.0) {
            return a;
        }
        return -a;
    }

    public static double[] abs(double[] a) {
        double[] ret = new double[a.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = MiniMatlab.abs(a[i]);
            ++i;
        }
        return ret;
    }

    public static int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static int min(int[] a) {
        int min = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] < min) {
                min = a[i];
            }
            ++i;
        }
        return min;
    }

    public static int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static int max(int[] a) {
        int max = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] > max) {
                max = a[i];
            }
            ++i;
        }
        return max;
    }

    public static double max(double[] a) {
        double max = 0.0;
        int i = 0;
        while (i < a.length) {
            if (a[i] > max) {
                max = a[i];
            }
            ++i;
        }
        return max;
    }

    public static BigDecimal max(BigDecimal[] a) {
        BigDecimal max = BigDecimal.ZERO;
        int i = 0;
        while (i < a.length) {
            if (a[i].compareTo(max) == 1) {
                max = a[i];
            }
            ++i;
        }
        return max;
    }

    public static double[] normalize(double[] a) {
        double max = MiniMatlab.max(MiniMatlab.abs(a));
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] / max;
        }
        return a;
    }

    public static BigDecimal[] abs(BigDecimal[] a) {
        int i = 0;
        while (i < a.length) {
            a[i] = a[i].abs();
            ++i;
        }
        return a;
    }

    public static double[] normalize(BigDecimal[] a) {
        BigDecimal max = MiniMatlab.max(MiniMatlab.abs(a));
        int i = 0;
        while (i < a.length) {
            a[i] = a[i].divide(max, 10, RoundingMode.HALF_UP);
            ++i;
        }
        double[] d = new double[a.length];
        int i2 = 0;
        while (i2 < d.length) {
            d[i2] = a[i2].doubleValue();
            ++i2;
        }
        return d;
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((x + 1.0) / (x - 1.0));
    }

    public static final double[] linspace(double begin, double end, int cnt) {
        double[] res = new double[cnt];
        double delta = (end - begin) / (double)(cnt - 1);
        res[0] = begin;
        int i = 1;
        while (i < res.length - 1) {
            res[i] = begin + (double)i * delta;
            ++i;
        }
        res[res.length - 1] = end;
        return res;
    }

    public static final double[] multiply(double[] a, double b) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * b;
        }
        return a;
    }

    public static final double[] ones(int i) {
        double[] p = new double[i];
        int j = 0;
        while (j < p.length) {
            p[j] = 1.0;
            ++j;
        }
        return p;
    }

    public static double[] real(Complex[] c) {
        double[] res = new double[c.length];
        int i = 0;
        while (i < res.length) {
            res[i] = c[i].getReal();
            ++i;
        }
        return res;
    }

    public static final double[] zeros(int i) {
        double[] p = new double[i];
        return p;
    }

    public static final Complex[] zerosC(int i) {
        Complex[] p = new Complex[i];
        int j = 0;
        while (j < p.length) {
            p[j] = new Complex(0.0, 0.0);
            ++j;
        }
        return p;
    }

    public static BigDecimal factorialBig(int num) {
        BigDecimal fact = BigDecimal.valueOf(1L);
        int i = 1;
        while (i <= num) {
            fact = fact.multiply(BigDecimal.valueOf(i));
            ++i;
        }
        return fact;
    }

    public static int factorial(int num) {
        int fact = 1;
        int i = 1;
        while (i <= num) {
            fact *= i;
            ++i;
        }
        return fact;
    }
}

