/*
 * Decompiled with CFR 0.152.
 */
package pro2e.matlabfunctions;

import java.math.BigDecimal;
import pro2e.matlabfunctions.MiniMatlab;

public class Fensterfunktionen {
    public static final int RECTANGULAR = 0;
    public static final int CHEBYSHEV = 1;
    public static final int BINOMIAL = 2;
    public static final int COSINE = 3;
    public static final int COSINESQUARE = 4;
    public static final int VONHANN = 5;
    public static final int HANNING = 6;
    public static final int BLACKMAN = 7;
    public static final int WELCH = 8;
    public static final int BARTLETT = 9;
    public static final int BARTLETTHANN = 10;
    public static final int TRIANGULAR = 11;
    public static final int EXPONENTIAL = 12;
    public static final int ROUND_FLOOR = 0;
    public static final int ROUND_CEIL = 1;
    public static final int ROUND_NEAREST = 2;

    public static double[] Quantize(double[] val, int bits) {
        double[] out = new double[val.length];
        int i = 0;
        while (i < val.length) {
            out[i] = Fensterfunktionen.RoundToBinary(val[i], bits, 2);
            ++i;
        }
        return out;
    }

    public static double Quantize(double val, int bits) {
        int resolution = (int)Math.pow(2.0, bits);
        double step = 1.0 / (double)resolution;
        double ret = 0.0;
        while (ret < val) {
            ret += step;
        }
        return ret;
    }

    public static double RoundToBinary(double val, int bits, int method) {
        int resolution = (int)Math.pow(2.0, bits);
        double step = 1.0 / (double)resolution;
        double ret = 0.0;
        if (method == 1) {
            ret = 0.0;
            while (ret < val) {
                ret += step;
            }
        }
        if (method == 0) {
            ret = Math.pow(2.0, bits);
            while (ret > val) {
                ret -= step;
            }
        }
        if (method == 2) {
            double stepn = 1.0 / (double)(resolution - 1);
            int round = 0;
            while (round < resolution) {
                if (Math.abs(val - (double)round * stepn) <= stepn / 2.0) {
                    ret = stepn * (double)round;
                }
                ++round;
            }
        }
        return ret;
    }

    public static double[] Rectangular(int N) {
        double[] out = new double[N];
        int i = 0;
        while (i < out.length) {
            out[i] = 1.0;
            ++i;
        }
        return out;
    }

    public static double[] Triangular(int N) {
        double[] FensterfunktionDreieck = new double[N];
        int i = 0;
        while (i < N / 2 + 1) {
            FensterfunktionDreieck[i] = 1.0 - Math.abs(((double)i - (double)N / 2.0) / ((double)N / 2.0));
            ++i;
        }
        int gerade = N % 2 == 0 ? 1 : 0;
        i = 0;
        while (i < N / 2 + gerade) {
            FensterfunktionDreieck[N - 1 - i] = FensterfunktionDreieck[i];
            ++i;
        }
        return FensterfunktionDreieck;
    }

    public static double[] Exponential(int N, double steigung) {
        double[] FensterExponential = new double[N];
        int i = 0;
        while (i < N) {
            FensterExponential[i] = Math.exp(-Math.abs((double)i - ((double)N - 1.0) / 2.0) * (1.0 / ((double)N * 8.69 / (2.0 * steigung))));
            ++i;
        }
        return FensterExponential;
    }

    public static double[] Binominal(int N) {
        double[] d = new double[N];
        if (N > 18) {
            BigDecimal[] out = new BigDecimal[N];
            int k = 0;
            while (k < out.length) {
                BigDecimal big;
                out[k] = big = MiniMatlab.nchoosekBig(N - 1, k);
                ++k;
            }
            d = MiniMatlab.normalize(out);
        } else {
            double[] out = new double[N];
            int k = 0;
            while (k < out.length) {
                double big;
                out[k] = big = (double)MiniMatlab.nchoosek(N - 1, k);
                ++k;
            }
            d = MiniMatlab.normalize(out);
        }
        return d;
    }

    private static double Cheby_poly(int n, double x) {
        double res = Math.abs(x) <= 1.0 ? Math.cos((double)n * Math.acos(x)) : Math.cosh((double)n * MiniMatlab.acosh(x));
        return res;
    }

    public static double[] Chebwin(int size, double atten) {
        double[] out = new double[size];
        double sum = 0.0;
        double max = 0.0;
        double tg = Math.pow(10.0, atten / 20.0);
        double x0 = Math.cosh(1.0 / (double)(size - 1) * MiniMatlab.acosh(tg));
        double M = (size - 1) / 2;
        if (size % 2 == 0) {
            M += 0.5;
        }
        int nn = 0;
        while (nn < size / 2 + 1) {
            double n = (double)nn - M;
            sum = 0.0;
            int i = 1;
            while ((double)i <= M) {
                sum += Fensterfunktionen.Cheby_poly(size - 1, x0 * Math.cos(Math.PI * (double)i / (double)size)) * Math.cos(2.0 * n * Math.PI * (double)i / (double)size);
                ++i;
            }
            out[nn] = tg + 2.0 * sum;
            out[size - nn - 1] = out[nn];
            if (out[nn] > max) {
                max = out[nn];
            }
            ++nn;
        }
        nn = 0;
        while (nn < size) {
            int n = nn++;
            out[n] = out[n] / max;
        }
        return out;
    }

    public static double[] Cosin(int size, double x) {
        double[] out = new double[size];
        int i = 0;
        while (i < size) {
            out[i] = x * Math.cos(Math.PI * (double)i / (double)(size - 1) - 1.5707963267948966) + (1.0 - x);
            ++i;
        }
        return out;
    }

    public static double[] CosinSquare(int size, double x) {
        double[] out = new double[size];
        int i = 0;
        while (i < size) {
            out[i] = Math.pow(x * Math.cos(Math.PI * (double)i / (double)(size - 1) - 1.5707963267948966) + (1.0 - x), 2.0);
            ++i;
        }
        return out;
    }

    public static double[] VonHann(int size) {
        double[] samples = new double[size];
        int i = 0;
        while (i < size) {
            samples[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(size - 1)));
            ++i;
        }
        return samples;
    }

    public static double[] Hanning(int size) {
        double[] samples = new double[size];
        int i = 0;
        while (i < size) {
            samples[i] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(size - 1)));
            ++i;
        }
        return samples;
    }

    public static double[] Blackman(int size) {
        double[] samples = new double[size];
        double alpha = 0.16;
        double a0 = (1.0 - alpha) / 2.0;
        double a1 = 0.5;
        double a2 = alpha / 2.0;
        int i = 0;
        while (i < size) {
            samples[i] = a0 - a1 * Math.cos(Math.PI * 2 * (double)i / (double)(size - 1)) + a2 * Math.cos(Math.PI * 4 * (double)i / (double)(size - 1));
            ++i;
        }
        return samples;
    }

    public static double[] Welch(int size) {
        double[] samples = new double[size];
        int i = 0;
        while (i < size) {
            samples[i] = 1.0 * (1.0 - Math.pow((double)(i - (size - 1) / 2) / (double)((size - 1) / 2), 2.0));
            ++i;
        }
        return samples;
    }

    public static double[] BartlettHann(int size) {
        double[] samples = new double[size];
        double a0 = 0.62;
        double a1 = 0.48;
        double a2 = 0.38;
        int i = 0;
        while (i < size) {
            samples[i] = a0 - a1 * Math.abs((double)i / (double)(size - 1) - 0.5) - a2 * Math.cos(Math.PI * 2 * (double)i / (double)(size - 1));
            ++i;
        }
        return samples;
    }
}

