/*
 * Decompiled with CFR 0.152.
 */
package pro2e;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pro2e.DPIFixV3;
import pro2e.controller.Controller;
import pro2e.model.Model;
import pro2e.userinterface.MenuBar;
import pro2e.userinterface.TopView;
import pro2e.userinterface.tutorial.SwingFXWebView;

public class DonutFramework
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String SHOW_TUTORIAL = "show_tutorial";
    private Mode mode = Mode.PACKEDRESIZABLE;
    private int width = 1200;
    private int height = 800;
    private Model model = new Model();
    private Controller controller = new Controller(this.model, this);
    private TopView view = new TopView(this.controller);
    private MenuBar menuBar = new MenuBar(this.controller, this);

    public void init() {
        this.model.addObserver(this.view);
        System.out.println("view @" + this.view.hashCode());
        this.model.addObserver(this.menuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.view, "Center");
        this.setJMenuBar(this.menuBar);
        DPIFixV3.scaleSwingFonts();
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
        switch (this.mode) {
            case FIXED: {
                this.setMinimumSize(this.getPreferredSize());
                this.setSize(this.width, this.height);
                this.setResizable(false);
                this.validate();
                break;
            }
            case FIXEDRESIZABLE: {
                this.setMinimumSize(this.getPreferredSize());
                this.setSize(this.width, this.height);
                this.setResizable(true);
                this.validate();
                break;
            }
            case PACKED: {
                this.setMinimumSize(this.getPreferredSize());
                this.setResizable(false);
                break;
            }
            case PACKEDRESIZABLE: {
                this.setMinimumSize(this.getPreferredSize());
                this.setResizable(true);
            }
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.view.actionPerformed(null);
    }

    public void setShowOnStartup(boolean value) {
        Preferences prefs = Preferences.userNodeForPackage(DonutFramework.class);
        prefs.putBoolean(SHOW_TUTORIAL, value);
    }

    public boolean getShowOnStartup() {
        Preferences prefs = Preferences.userNodeForPackage(DonutFramework.class);
        return prefs.getBoolean(SHOW_TUTORIAL, true);
    }

    public void showTutorial() {
        JFrame tutorial = new JFrame();
        tutorial.setTitle("Tutorial");
        try {
            tutorial.setIconImage(ImageIO.read(DonutFramework.class.getResourceAsStream("Icon.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        tutorial.setSize(screenSize.width / 2, screenSize.height / 5 * 4);
        tutorial.setLocation(screenSize.width / 4, screenSize.height / 7);
        tutorial.setMinimumSize(new Dimension(screenSize.width / 5, screenSize.height / 5));
        SwingFXWebView tutorialWindow = new SwingFXWebView();
        tutorial.add(tutorialWindow);
        tutorial.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DonutFramework frame = new DonutFramework();
                frame.setDefaultCloseOperation(3);
                frame.setTitle("Donut Antennentool");
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int width = screenSize.width;
                int height = screenSize.height;
                frame.setPreferredSize(new Dimension(2 * width / 5, 3 * height / 5));
                try {
                    frame.setIconImage(ImageIO.read(DonutFramework.class.getResourceAsStream("Icon.png")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                frame.init();
                frame.setVisible(true);
                if (frame.getShowOnStartup()) {
                    BufferedImage logo = null;
                    try {
                        logo = ImageIO.read(DonutFramework.class.getResourceAsStream("Icon.png"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ImageIcon logoIcon = new ImageIcon(logo);
                    JCheckBox checkbox = new JCheckBox("Diesen Dialog nicht mehr anzeigen.");
                    Object[] message = new Object[]{"Willkommen beim Donut Antennentool", "Wollen Sie das Tutorial starten?", logoIcon, checkbox};
                    JOptionPane startupDialog = new JOptionPane(message, -1, 0);
                    JDialog dialog = startupDialog.createDialog(null, "Tutorial");
                    width /= 3;
                    dialog.setLocation(screenSize.width / 3, screenSize.height / 3);
                    if (dialog.getHeight() > (height /= 3)) {
                        height = dialog.getHeight();
                    }
                    if (dialog.getWidth() > width) {
                        width = dialog.getWidth();
                    }
                    dialog.setSize(width, height);
                    dialog.setVisible(true);
                    Object selectedValue = startupDialog.getValue();
                    int n = -1;
                    n = selectedValue == null ? -1 : Integer.parseInt(selectedValue.toString());
                    if (n == 0) {
                        frame.showTutorial();
                    }
                    if (checkbox.isSelected()) {
                        System.out.println("nicht mehr anzeigen");
                        frame.setShowOnStartup(false);
                    }
                }
            }
        });
    }

    public static class Colors {
        public static final Color Pink = new Color(16728197);
        public static final Color Beige = new Color(16765296);
        public static final Color Blue = new Color(6534886);
        public static final Color Green = new Color(8708192);
        public static final Color Purple = new Color(9906636);
    }

    private static enum Mode {
        FIXED,
        PACKED,
        FIXEDRESIZABLE,
        PACKEDRESIZABLE;

    }
}

